% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{plotPermTest}
\alias{plotPermTest}
\title{plotPermTest}
\usage{
plotPermTest(df, simulationData, densityToDistr = FALSE)
}
\arguments{
\item{df}{A DataFrame.}

\item{simulationData}{The output of the calculateSRDDistribution() function.}

\item{densityToDistr}{Flag to display the cumulative distribution function instead of the probability density.}
}
\value{
None.
}
\description{
Plots the permutation test for the given data frame by
using the simulation data created by the calculateSRDDistribution() function.
}
\examples{
\donttest{
df <- data.frame(
A=c(32, 52, 44, 44, 47),
B=c(73, 75, 65, 76, 70),
C=c(60, 59, 57, 55, 60),
D=c(35, 24, 44, 83, 47),
E=c(41, 52, 46, 50, 65))

simulationData <- rSRD::calculateSRDDistribution(df)
plotPermTest(df, simulationData)
}
}
\author{
Linus Olsson \email{linusmeol@gmail.com}
}
