% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{reset_shapeDB}
\alias{reset_shapeDB}
\title{This is a convenience function to refresh connections to database files.}
\usage{
reset_shapeDB(func_conName, func_existingCon = NULL,
  func_type = "connect")
}
\arguments{
\item{func_conName}{The filepath to which an SQLite connection is sought.}

\item{func_existingCon}{If any value other than NULL, then any existing connection is first dropped
prior to attempting to form a connection to the func_conName filepath.}

\item{func_type}{This should be a character string of either \strong{connect}, in which case a
connection is made/refreshed to the filepath in func_conName", or any other value will cause disconnection}
}
\value{
An SQLite connection object to an SQLite database.
}
\description{
This is a convenience function to refresh connections to database files.
}
\examples{
# This function can be called to set, resset SQL connections
fileName_testCon <- paste(tempdir(),"/testCon.sqlite",sep="")
testCon <- reset_shapeDB(fileName_testCon)
reset_shapeDB(testCon, func_type = "disconnect")

}
