% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{nameTable_step}
\alias{nameTable_step}
\title{This is a standardising function which allows SHAPE to programatiically name tables for the step-wise record OR split
a named table and extract the embedded information from its naming.}
\usage{
nameTable_step(func_Index, funcSplit = FALSE,
  func_sepString = getOption("shape_sepString"))
}
\arguments{
\item{func_Index}{Integer value(s) for the step of a SHAPE run which will be recorded by this table}

\item{funcSplit}{A logical toggle to control if this function is splitting a named table or not.  So, FALSE (default)
means we're creating a table name whereas TRUE is splitting a named table into it's parts.}

\item{func_sepString}{This is a character string used to collapse vectors of characters.}
}
\value{
If funcSplit is TRUE, then a vector of table names is returned.  If FALSE, we split the table and return the
data detailing the step number being recorded on the named table.
}
\description{
This is a standardising function which allows SHAPE to programatiically name tables for the step-wise record OR split
a named table and extract the embedded information from its naming.
}
\examples{
# This creates a table name in a standard way, it can also split table names to extract info.
defineSHAPE()
nameTable_step(2,FALSE)
nameTable_step("Step_2",TRUE)

}
