% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{calc_relativeFitness}
\alias{calc_relativeFitness}
\title{This is a function to calculate the relative fitness for a vector of fitnesses.  As a frame of reference
it can use either an ancestral fitness value or the mean fitness of the passed vector.  If the frame of
reference is a value of zero - OR - the func_absDistance is set to TRUE then instead the vector is centered
around a value of 1 where negative values will be set to zero.}
\usage{
calc_relativeFitness(func_fitVector, func_ancestFit = NULL,
  func_weights = NULL, func_absDistance = (getOption("shape_simModel")
  == "RMF"))
}
\arguments{
\item{func_fitVector}{a numeric vector of values to be interpreted as fitnesses}

\item{func_ancestFit}{An optional single numeric value to be used as a frame of reference
for calculating relative fitness.}

\item{func_weights}{An optional vector of weights to be used for calculating relative fitness
as an absolute distance from the mean of the func_fitVector vector.}

\item{func_absDistance}{A logical toggle to override if relative fitnesses are to be calculated as the absolute
distance from 1.  Will be overrode if either the mean of func_fitVector or func_ancestFit are zero.}
}
\value{
A vector of relative fitness values of length equal to the input vector.
}
\description{
This is a function to calculate the relative fitness for a vector of fitnesses.  As a frame of reference
it can use either an ancestral fitness value or the mean fitness of the passed vector.  If the frame of
reference is a value of zero - OR - the func_absDistance is set to TRUE then instead the vector is centered
around a value of 1 where negative values will be set to zero.
}
\examples{
# This calculates relative fitness values either based on the mean of the community or
# based on an ancestral fitness value.
defineSHAPE()
calc_relativeFitness(c(0.9,1,1.1))
calc_relativeFitness(c(0.9,1,1.1),func_ancestFit = 0)
calc_relativeFitness(c(0.9,1,1.1),func_ancestFit = 1)
calc_relativeFitness(c(0.95,1,1.1))

}
