% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowerIteration.R
\name{PowerIteration}
\alias{PowerIteration}
\title{Title}
\usage{
PowerIteration(
  tnsr,
  m,
  k,
  rank = NULL,
  type = "TWIST",
  U_0_list,
  delta1 = 1000,
  delta2 = 1000,
  max_iter = 5,
  tol = 1e-05
)
}
\arguments{
\item{tnsr}{the adjacency tensor of the network}

\item{m}{the number of types of the network}

\item{k}{the number of groups of vertices}

\item{rank}{the rank of the core tensor calculated by the equation}

\item{type}{specifies the iterative algorithm to run ‘TWIST’ or ‘Tucker’}

\item{U_0_list}{InitializationMMSBM outputs}

\item{delta1}{tuning parameters for regularization in mode1}

\item{delta2}{tuning parameters for regularization in mode2}

\item{max_iter}{the max times of iteration}

\item{tol}{the convergence tolerance}
}
\value{
a list including the core tensor Z, network embedding and node embedding
}
\description{
Title
}
\examples{
tnsr = GenerateMMSBM(200, 3, 10, 2, d = NULL, r = NULL)
U_list = InitializationMMSBM(tnsr, 3, 2, rank = NULL)
embed_list = PowerIteration(tnsr,3,2,rank=NULL,type="TUCKER",U_0_list=U_list)
}
