% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtr.layer.segments.R
\name{depth.filter}
\alias{depth.filter}
\title{Data filter to remove soak, heave and upcast}
\usage{
depth.filter(z0, run_length = 20, index = FALSE)
}
\arguments{
\item{z0}{depth vector}

\item{run_length}{Length of run upon which to start the soak removal}

\item{index}{Logical: Should the function return an index value or actual
value?}
}
\value{
index values of z0 of filtered data. Will return a warning if the
function removed more than 10% of the data
}
\description{
\itemize{ \item Soak period: water profiling instruments typically require a
soak period where you let the instrument rest submerged at the surface.
While it is "soaking" it is collecting data. We don't want that data \item
Upcast versus downcast: typically instruments are turned on before you put
them in the water and turn them off once you pull them out. The data
consequence of that is that you collect both the "downcast" and the
"upcast". In some case the upcast is of interest but usually it isn't. And
because we would prefer increasing depth data it is better to remove an
upcast if it is present.  \item Heave: when lowering the instrument in rough
weather a boat will heave side to side. Sometimes it will heave enough that
you get small data groupings where the decreases a little while the boat
heaves then go down. The overall trend is still down but those slight
upticks in depth cause problems for our algorithm. }
}
