% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{cgm_auc}
\alias{cgm_auc}
\title{Calculate area under the curve (AUC)}
\usage{
cgm_auc(x, times, thresh = 100, above = TRUE)
}
\arguments{
\item{x}{vector of glucose readings}

\item{times}{vector of corresponding times, in minutes}

\item{thresh}{threshold above (or below) which you wish to calculate the AUC. Default is 100.}

\item{above}{logical indicating whether you wish to calculate area above the threshold value (TRUE) or below it (FALSE). Default is TRUE.}
}
\value{
The numeric area under the curve value for a given dataset of glucose measurements and times.
}
\description{
Calculate area under the curve (AUC)
}
\examples{
cgm_auc(x=c(rep(100, 10), rep(120, 10), 105, 85), times=seq(0, 1260, 60), thresh=110, above=TRUE)
}
