% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmr.R
\name{gmr}
\alias{gmr}
\title{Generalized Means Rotation (GMR)}
\usage{
gmr(V, X)
}
\arguments{
\item{V}{A matrix containing ENA set points for projection.}

\item{X}{A data frame containing all predictor variables, with the first column as the target variable.}
}
\value{
A numeric vector representing the rotation.
}
\description{
Computes the generalized means rotation for a given set of ENA points and predictor variables.
}
\details{
If \code{X} has only one column, a linear model is fit between \code{V} and the single predictor.
Otherwise, the main effect of the first predictor is extracted using \code{get_x1_main_effect}.
Singular value decomposition (SVD) is then performed, and the first right singular vector is used
to project the data. A linear model is fit to the projected data, and the coefficients are normalized
to produce the rotation vector.
}
\examples{
\dontrun{
V <- matrix(rnorm(100), ncol = 5)
X <- data.frame(target = rnorm(20), predictor1 = rnorm(20), predictor2 = rnorm(20))
r <- gmr(V, X)
}

}
\seealso{
\code{\link{get_x1_main_effect}}
}
