% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_detect.R
\name{vstPermutation}
\alias{vstPermutation}
\title{Run permutation on Vst}
\usage{
vstPermutation(
  AD,
  pops,
  nperm = 100,
  histogram = TRUE,
  stat = 2,
  qGraph = TRUE
)
}
\arguments{
\item{AD}{data frame of total allele depth values of SNPs}

\item{pops}{character. A vector of population names for each individual.
Must be the same length as the number of samples in AD}

\item{nperm}{numeric. Number of permutations to perform}

\item{histogram}{logical. plots the distribution histogram of permuted vst values vs. observed values}

\item{stat}{numeric. The stat to be plotted in histogram. 1 for Mean Absolute Distance or 2 (\code{default}) for Root Mean Square Distance}

\item{qGraph}{logical. Plot the network plot based on observed Vst values
(see \code{vst()} help page for more details)}
}
\value{
Returns a list with observed vst values, an array of permuted vst values and the p-values for the permutation test
}
\description{
This function runs a permutation test on Vst calculation
}
\examples{
\dontrun{data(alleleINF)
data(ADtable)
DD<-dupGet(alleleINF)
ds<-DD[DD$dup.stat=="deviant",]
ad<-ADtable[match(paste0(ds$CHROM,".",ds$POS),paste0(ADtable$CHROM,".",ADtable$POS)),]
vstPermutation(ad,pops=substr(colnames(ad)[-c(1:4)],1,11))}

}
\author{
Jorge Cortés-Miranda (email:\href{mailto:jorge.cortes.m@ug.uchile.cl}{jorge.cortes.m@ug.uchile.cl}), Piyal Karunarathne
}
