% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_dt.R
\name{clean_dt}
\alias{clean_dt}
\title{clean_dt helper function}
\usage{
clean_dt(
  datatable,
  description = c("calibration", "experimental"),
  type = 1L,
  logfilename
)
}
\arguments{
\item{datatable}{A data.table object that contains either the experimental
data or the calibration data.}

\item{description}{A character string, indicating if \code{datatable}
contains either \emph{"calibration"} data or \emph{"experimental"} data.}

\item{type}{A single integer. Type of data to be corrected: either \code{1L} (one
locus in many samples, e.g. pyrosequencing data) or \code{2L} (many loci in one
sample, e.g. next-generation sequencing data or microarray data).}

\item{logfilename}{A character string. Path to a file to save the log
messages (default = paste0(tempdir(), "/log.txt")).}
}
\value{
If a valid file is provided, the function returns a cleaned
data.table, suited for BiasCorrection.
}
\description{
Internal function, that checks the formatting of imported
files and prepares them to be applicable for the following pcr-bias
correction steps.
}
\examples{
logfilename <- paste0(tempdir(), "/log.txt")
cleaned_experimental <- clean_dt(
  datatable = rBiasCorrection::example.data_experimental$dat,
  description = "experimental",
  type = 1,
  logfilename = logfilename
)
dim(cleaned_experimental)
class(cleaned_experimental)

}
