% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populate_multiple_folders.R
\name{populate_multiple_folders}
\alias{populate_multiple_folders}
\title{Populate multiple Stock Synthesis folders with input files}
\usage{
populate_multiple_folders(
  outerdir.old = NULL,
  outerdir.new = NULL,
  create.dir = TRUE,
  overwrite = FALSE,
  use_ss_new = FALSE,
  exe.dir = NULL,
  exe.file = "ss.exe",
  exe.only = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{outerdir.old}{Location of existing outer directory containing
subdirectories for each model.}

\item{outerdir.new}{New outer directory into which the subfolders
should be created.}

\item{create.dir}{Create new outer directory if it doesn't exist already?}

\item{overwrite}{Overwrite existing files with matching names?}

\item{use_ss_new}{Use .ss_new files instead of original inputs?}

\item{exe.dir}{Path to executable to copy into all the subfolders.}

\item{exe.file}{Filename of executable to copy into all the subfolders.
A value of NULL will skip copying the executable.}

\item{exe.only}{Only copy exe files from exe.dir, don't copy input files}

\item{verbose}{Return updates of function progress to the R console?}
}
\value{
Returns table of results indicating which directories were
successfully populated with the model input files and/or executables
}
\description{
Creates a set of multiple folders and populate each with SS input files
such as for the purpose of running a new version of SS for an existing
set of test models.
}
\examples{
\dontrun{
populate_multiple_folders(
  outerdir.old = "c:/SS/old_models",
  outerdir.new = "c:/SS/new_models",
  exe.dir = "c:/SS/SSv3.30.12.00"
)
}

}
\seealso{
\code{\link[=copy_SS_inputs]{copy_SS_inputs()}}
}
\author{
Ian Taylor
}
