% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSsummarize.R
\name{SSsummarize}
\alias{SSsummarize}
\title{Summarize the output from multiple Stock Synthesis models.}
\usage{
SSsummarize(
  biglist,
  sizeselfactor = "Lsel",
  ageselfactor = "Asel",
  selfleet = NULL,
  selyr = "startyr",
  selgender = 1,
  SpawnOutputUnits = NULL,
  lowerCI = 0.025,
  upperCI = 0.975,
  verbose = TRUE
)
}
\arguments{
\item{biglist}{A list of lists, one for each model. The individual lists can
be created by \code{\link[=SS_output]{SS_output()}} or the list of lists can be
created by \code{\link[=SSgetoutput]{SSgetoutput()}} (which iteratively calls
\code{\link[=SS_output]{SS_output()}}).}

\item{sizeselfactor}{A string or vector of strings indicating which elements
of the selectivity at length output to summarize. Default=c("Lsel").}

\item{ageselfactor}{A string or vector of strings indicating which elements
of the selectivity at age output to summarize. Default=c("Asel").}

\item{selfleet}{Vector of fleets for which selectivity will be summarized.
NULL=all fleets. Default=NULL.}

\item{selyr}{String or vector of years for which selectivity will be
summarized.  NOTE: NOT CURRENTLY WORKING.  Options: NULL=all years,
"startyr" = first year.}

\item{selgender}{Vector of genders (1 and/or 2) for which selectivity will
be summarized. NULL=all genders. Default=NULL.}

\item{SpawnOutputUnits}{Optional single value or vector of "biomass" or
"numbers" giving units of spawning for each model.}

\item{lowerCI}{Quantile for lower bound on calculated intervals. Default =
0.025 for 95\% intervals.}

\item{upperCI}{Quantile for upper bound on calculated intervals. Default =
0.975 for 95\% intervals.}

\item{verbose}{A logical value specifying if output should be printed
to the screen.}
}
\description{
Summarize various quantities from the model output collected by
\code{\link[=SSgetoutput]{SSgetoutput()}} and return them in a list of tables and vectors.
}
\seealso{
\code{\link[=SSgetoutput]{SSgetoutput()}}
}
\author{
Ian Taylor
}
