% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotSexRatio.R
\name{SSplotSexRatio}
\alias{SSplotSexRatio}
\title{Plot sex-ratio data and fits for two sex models}
\usage{
SSplotSexRatio(
  replist,
  kind = "AGE",
  sexratio.option = 2,
  CI = 0.75,
  plot = TRUE,
  print = FALSE,
  fleets = "all",
  fleetnames = "default",
  yupper = 4,
  datonly = FALSE,
  linescol = rgb(0.6, 0, 0.9, 0.7),
  lwd = 2,
  showsampsize = TRUE,
  showeffN = TRUE,
  axis1 = NULL,
  axis2 = NULL,
  pwidth = 6.5,
  pheight = 5,
  punits = "in",
  ptsize = 10,
  res = 300,
  plotdir = "default",
  cex.main = 1,
  labels = c("Length (cm)", "Age (yr)", "Sex ratio (females:males)", "Fraction female"),
  maxrows = 6,
  maxcols = 6,
  rows = 1,
  cols = 1,
  fixdims = TRUE,
  verbose = TRUE,
  mainTitle = FALSE,
  ...
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{kind}{indicator of type of plot can be "LEN", "SIZE", "AGE", "cond",
"GSTAGE", "L@A", or "W@A".}

\item{sexratio.option}{code to choose among (1) female:male ratio or
(2) fraction females out of the total}

\item{CI}{confidence interval for uncertainty}

\item{plot}{plot to active plot device?}

\item{print}{print to PNG files?}

\item{fleets}{optional vector to subset fleets for which plots will be made}

\item{fleetnames}{optional vector of fleet names to put in the labels}

\item{yupper}{upper limit on ymax (only applies for sexratio.option == 1)}

\item{datonly}{make plots of data without fits?}

\item{linescol}{Color for line showing expected value (default is purple).}

\item{lwd}{line width}

\item{showsampsize}{add sample sizes to plot}

\item{showeffN}{add effective sample sizes to plot}

\item{axis1}{position of bottom axis values}

\item{axis2}{position of left size axis values}

\item{pwidth}{default width of plots printed to files in units of
\code{punits}. Default=7.}

\item{pheight}{default height width of plots printed to files in units of
\code{punits}. Default=7.}

\item{punits}{units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" or "mm". Default="in".}

\item{ptsize}{point size for plotted text in plots printed to files (see
help("png") in R for details). Default=12.}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{plotdir}{directory where PNG files will be written. by default it will
be the directory where the model was run.}

\item{cex.main}{character expansion parameter for plot titles}

\item{labels}{vector of labels for plots (titles and axis labels)}

\item{maxrows}{maximum (or fixed) number or rows of panels in the plot}

\item{maxcols}{maximum (or fixed) number or columns of panels in the plot
plots}

\item{rows}{number or rows to return to as default for next plots to come or
for single plots}

\item{cols}{number or cols to return to as default for next plots to come or
for single plots}

\item{fixdims}{fix the dimensions at maxrows by maxcols or resize based on
number of years of data}

\item{verbose}{return updates of function progress to the R GUI?}

\item{mainTitle}{Logical indicating if a title for the plot should be produced}

\item{\dots}{additional arguments that will be passed to the plotting.}
}
\description{
Plot sex-ratio data and fits from Stock Synthesis output.  Multi-figure
plots depend on \code{make_multifig}. The confidence intervals around the
observed points are based on a Jeffreys interval calculated from
the adjusted input sample size (with a floor of 1).
}
\references{
Brown, L.; Cai, T. Tony; DasGupta, A. (2001).
Interval Estimation for a Binomial Proportion. Statistical Science.
16(2): 101-133. http://www.jstor.org/stable/2676784.
}
\seealso{
\code{\link[=SS_plots]{SS_plots()}}, \code{\link[=make_multifig_sexratio]{make_multifig_sexratio()}}
}
\author{
Cole Monnahan, Ian Taylor
}
