% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_writewtatage.R
\name{SS_writewtatage}
\alias{SS_writewtatage}
\title{Write weight-at-age file}
\usage{
SS_writewtatage(
  mylist,
  dir = NULL,
  file = "wtatage.ss",
  overwrite = FALSE,
  verbose = TRUE,
  warn = TRUE
)
}
\arguments{
\item{mylist}{Object created by \code{\link[=SS_readwtatage]{SS_readwtatage()}}.}

\item{dir}{A file path to the directory of interest.
Typically used with \code{file}, an additional input argument,
to specify input and output file paths.
The default value is \code{dir = NULL}, which leads to using
the current working directory, and thus, full file paths should
not be specified for other arguments as they will be appended
to \code{dir}.}

\item{file}{Filename for new weight-at-age file, which
will be appended to \code{dir} to create a full file path.
Default="wtatage.ss".}

\item{overwrite}{A logical value specifying if the existing file(s)
should be overwritten. The default value is \code{overwrite = FALSE}.}

\item{verbose}{A logical value specifying if output should be printed
to the screen.}

\item{warn}{A logical value specifying if a warning should be
generated if overwriting \code{file}.
The default value is \code{warn = TRUE}.}
}
\description{
Write Stock Synthesis weight-at-age file from R object that was probably
created using \code{\link[=SS_readwtatage]{SS_readwtatage()}}
}
\seealso{
\code{\link[=SS_readwtatage]{SS_readwtatage()}}
}
\author{
Kelli F. Johnson
}
