% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_readdat.R
\name{SS_readdat}
\alias{SS_readdat}
\title{read Stock Synthesis data file}
\usage{
SS_readdat(
  file,
  version = "3.30",
  verbose = TRUE,
  echoall = FALSE,
  section = NULL
)
}
\arguments{
\item{file}{Filename either with full path or relative to working directory.

See the formal arguments for a possible default filename.}

\item{version}{SS version number.
Currently "2.00", "3.00", "3.24" or "3.30" are supported,
either as character or numeric values (noting that numeric 3.30  = 3.3). If
version is NULL, the version (3.24 or 3.30) will be looked for on the first
line of the file.}

\item{verbose}{Should there be verbose output while running the file?
Default=TRUE.}

\item{echoall}{Debugging tool (not fully implemented) of echoing blocks of
data as it is being read.}

\item{section}{Which data set to read. Only applies for a data.ss_new file
created by Stock Synthesis. Allows the choice of either expected values
(section=2) or bootstrap data (section=3+). Leaving default of section=NULL
will read input data, (equivalent to section=1).}
}
\description{
Read Stock Synthesis data file into list object in R. This function is a
wrapper which calls SS_readdat_2.00, SS_readdat_3.00, SS_readdat_3.24, or SS_readdat_3.30
(and potentially additional functions in the future). This setup allows those
functions to be cleaner (if somewhat redundant) than a single function that
attempts to do everything. Returned datlist is mostly consistent across versions.
}
\seealso{
\code{\link[=SS_readdat_2.00]{SS_readdat_2.00()}}, \code{\link[=SS_readdat_3.00]{SS_readdat_3.00()}},
\code{\link[=SS_readdat_3.24]{SS_readdat_3.24()}}, \code{\link[=SS_readdat_3.30]{SS_readdat_3.30()}},
\code{\link[=SS_readctl]{SS_readctl()}}, \code{\link[=SS_readctl_3.24]{SS_readctl_3.24()}}
\code{\link[=SS_readstarter]{SS_readstarter()}}, \code{\link[=SS_readforecast]{SS_readforecast()}},
\code{\link[=SS_writestarter]{SS_writestarter()}},
\code{\link[=SS_writeforecast]{SS_writeforecast()}}, \code{\link[=SS_writedat]{SS_writedat()}}
}
\author{
Ian G. Taylor, Allan C. Hicks, Neil L. Klaer, Kelli F. Johnson,
Chantel R. Wetzel
}
