% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nasapower.R
\name{get_nasapower}
\alias{get_nasapower}
\title{Fetch NASA POWER Data for Multiple Locations with a Progress Bar}
\usage{
get_nasapower(
  data,
  days_around,
  date_col,
  pars = c("T2M", "RH2M", "PRECTOTCORR", "T2M_MAX", "T2M_MIN", "T2MDEW")
)
}
\arguments{
\item{data}{A data frame containing the input data, including columns for latitude, longitude, study identifier,
and the date column.}

\item{days_around}{An integer specifying the number of days before and after the date in the date column
to download data.}

\item{date_col}{A character string specifying the name of the date column in the data frame.}

\item{pars}{A character vector specifying the weather variables to fetch from NASA POWER
(default: c("T2M", "RH2M", "PRECTOTCORR", "T2M_MAX", "T2M_MIN", "T2MDEW")).}
}
\value{
A data frame with the downloaded weather data from NASA POWER, combined for all specified locations.
Includes a new variable \code{study} indicating the study identifier from the input data.
Returns an empty data frame if no data is retrieved.
}
\description{
This function downloads daily NASA POWER data for specified weather variables over a specified number of days
around a given date column for multiple locations. It includes a progress bar to show the download progress.
}
\details{
The function uses the \code{get_power} function from the \code{nasapower} package to fetch weather data for a range of
dates around the specified date column for each location. A progress bar is shown during the data download
process, and the results are combined into a single data frame.
}
\seealso{
Other Disease modeling: 
\code{\link{windowpane}()}
}
\concept{Disease modeling}
