% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineup_prop_boot.R
\name{lineup_prop_boot}
\alias{lineup_prop_boot}
\title{Bootstrapped lineup proportion}
\usage{
lineup_prop_boot(lineup_vec, d, target_pos)
}
\arguments{
\item{lineup_vec}{A numeric vector of lineup choices}

\item{d}{Indices for bootstrap sample. Argument used by boot function to
select samples for bootstrapping}

\item{target_pos}{A scalar, representing target position in lineup. Must be declared by user}
}
\description{
Base function for computing bootstrapped lineup proportion for a lineup member
}
\details{
Function to call when bootstrap resampling using boot function
}
\examples{
lineup_vec <- round(runif(100, 1, 6))

bootobject <- boot::boot(lineup_vec, lineup_prop_boot, target_pos = 3, R = 1000)
cis <- boot::boot.ci(bootobject, conf = 0.95, type = "all")

}
\references{
Davison,  A.C. & Hinkley,  D.V. (1997). \emph{Bootstrap methods and their
           application}. Cambridge University Press.

           Wells, G. L.,Leippe, M. R., & Ostrom, T. M. (1979). Guidelines for
           empirically assessing the fairness of a lineup. \emph{Law and Human Behavior,
           3}(4), 285-293.
}
\seealso{
\code{\link[boot:boot]{boot}}: https://cran.r-project.org/web/packages/boot/boot.pdf
}
