% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_esize_m_ci.R
\name{gen_esize_m_ci}
\alias{gen_esize_m_ci}
\title{Bootstrapped Confidence Intervals for Effective Size}
\usage{
gen_esize_m_ci(lineupsizes, perc = 0.05)
}
\arguments{
\item{lineupsizes}{A vector of bootstrapped effective sizes}

\item{perc}{Defaults to .05. Can be specified by user, according to desired
level of alpha (scalar)}
}
\value{
Confidence intervals for effective size
}
\description{
Function for computing Effective Size (Malpass, 1981, as adjusted by Tredoux, 1998)
with CIs from bootstrap df of lineups
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1, 6))
k <- 6

#Use gen_boot_samples to get bootstrapped data:
bootdata <- gen_boot_samples(lineup_vec, 1000)

#Compute effective size over df of bootstrapped data:
lineupsizes <- gen_esize_m(bootdata, 6)

#Call:
gen_esize_m_ci(lineupsizes)
gen_esize_m_ci(lineupsizes, perc = .025)
gen_esize_m_ci(lineupsizes, perc = .975)

}
