% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_size_report.R
\name{func_size_report}
\alias{func_size_report}
\title{Functional Size with Bootstrapped Confidence Intervals}
\usage{
func_size_report(lineup_vec, target_pos, k, R)
}
\arguments{
\item{lineup_vec}{A numeric vector of lineup choices}

\item{target_pos}{A scalar, representing target position in lineup. Must be declared by user}

\item{k}{Number of members in lineup. Must be specified by user (scalar).}

\item{R}{Number of bootstrap samples. Defaults to 1000}
}
\description{
This function is a master function, calling other functions it needs,
and reporting results in some detail
}
\details{
Function depends on functions from package 'boot'
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1, 6))
target_pos <- 3

#Call:
x <- func_size_report(lineup_vec, target_pos, 6)
x <- func_size_report(lineup_vec, 3, 6)

}
\references{
Davison,  A.C. & Hinkley,  D.V. (1997). \emph{Bootstrap methods and their
           application}. Cambridge University Press.

           Tredoux, C. G. (1998). Statistical inference on measures of lineup fairness.
           \emph{Law and Human Behavior, 22}(2), 217-237.

           Tredoux, C. (1999). Statistical considerations when determining measures of
           lineup size and lineup bias. \emph{Applied Cognitive Psychology}, 13, S9-S26.

           Wells, G. L.,Leippe, M. R., & Ostrom, T. M. (1979). Guidelines for
           empirically assessing the fairness of a lineup. \emph{Law and Human Behavior,
           3}(4), 285-293.
}
\seealso{
\code{\link[boot:boot]{boot}}: https://cran.r-project.org/web/packages/boot/boot.pdf
}
