% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{m_set_projection}
\alias{m_set_projection}
\title{Set view projection scheme}
\usage{
m_set_projection(id, scheme = c("perspective", "orthographic"))
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{scheme}{Either \code{orthographic} or \code{perspective}.
Default is \code{perspective}. Orthographic can also be enabled on viewer
creation by setting \code{orthographic} to true in the config object.}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Set view projection scheme
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_set_style(style = m_style_cartoon()) \%>\%
  m_set_projection(scheme = "orthographic")
}
