% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{m_grid}
\alias{m_grid}
\title{Create a grid of viewers that share a WebGL canvas}
\usage{
m_grid(
  viewer,
  element_id,
  rows = NULL,
  cols = NULL,
  control_all = TRUE,
  viewer_config = m_viewer_spec(),
  width = NULL,
  height = NULL
)
}
\arguments{
\item{viewer}{A list contains sub-viewers.}

\item{element_id}{HTML string identifier.}

\item{rows}{Number of rows in viewer grid.}

\item{cols}{Number of columns in viewer grid.}

\item{control_all}{Logical, simaultaneous mouse control of all windows in the
grid.}

\item{viewer_config}{Viewer specification to apply to all subviewers.}

\item{width}{Fixed width for combined viewer (in css units). Ignored when
used in a Shiny app -- use the \code{width} parameter in
\code{\link[r3dmol]{r3dmolOutput}}.
It is not recommended to use this parameter because the widget knows how to
adjust its width automatically.}

\item{height}{Fixed height for combined viewer (in css units). It is
recommended to not use this parameter since the widget knows how to adjust
its height automatically.}
}
\value{
An \code{r3dmol} object (the output from \code{r3dmol()}).
}
\description{
Create a grid of viewers that share a WebGL canvas
}
\examples{
library(r3dmol)

m1 <- r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_zoom_to()

m2 <- m1 \%>\%
  m_set_style(style = m_style_cartoon(color = "spectrum"))

m3 <- m1 \%>\%
  m_set_style(style = m_style_stick())

m4 <- m1 \%>\%
  m_set_style(style = m_style_sphere())

m_grid(
  viewer = list(m1, m2, m3, m4),
  control_all = TRUE,
  viewer_config = m_viewer_spec(
    backgroundColor = "black"
  )
)
}
