% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdownResizer.R
\name{add.resizer}
\alias{add.resizer}
\title{Configure toolbar settings for the page}
\usage{
add.resizer(
  theme.color = NULL,
  position = c("top", "bottom"),
  font.size = NULL,
  font.color = NULL,
  tables = TRUE,
  images = TRUE,
  line.color = NULL,
  thumb.width = NULL,
  thumb.height = NULL,
  line.width = NULL,
  line.height = NULL,
  dim.units = "px",
  default.image.width = NULL
)
}
\arguments{
\item{theme.color}{theme color for resizer and table e.g. black or #000000}

\item{position}{position of the resize toolbar e.g. top or bottom}

\item{font.size}{size of the page font in px e.g. 14px}

\item{font.color}{color of the page font in e.g. darkblue or #006699}

\item{tables}{boolean. TRUE or FALSE, to add resize toobar to tables}

\item{images}{boolean. TRUE or FALSE, to add resize toobar to images}

\item{line.color}{color of the resizer track e.g. red or #f5f5f5}

\item{thumb.width}{width of the resizer thumb e.g. 25}

\item{thumb.height}{height of the resizer thumb e.g. 25}

\item{line.width}{width of the resizer track e.g. 200}

\item{line.height}{height of the resizer track e.g. 10}

\item{dim.units}{unit for the height and width of the track or thumb}

\item{default.image.width}{default width of all images on the page e.g. 100}
}
\value{
Inclusion of mini toolbar for images and tables within a page
}
\description{
Set options for the inclusion of sizing toolbar in documents
}
\section{Examples for r2resize}{

More examples and demo pages for this function are located at this link -
\url{https://r2resize.obi.obianom.com}.
}

\examples{
# default settings
r2resize::add.resizer()

# add resizer to only images
r2resize::add.resizer(
  tables = FALSE,
  images = TRUE
 )


# add resizer to only tables
r2resize::add.resizer(
  tables = TRUE,
  images = FALSE
 )


# add resizer to both images
r2resize::add.resizer(
  tables = TRUE,
  images = TRUE
 )

# set position of the resize toolbar
r2resize::add.resizer(
  position = "top" #this is the default, another is 'bottom'
 )

# set resizer line color, height and width
r2resize::add.resizer(
  line.color = "green",
  line.width = 150,
  line.height = 5
 )


#declare more arguments including default image size
r2resize::add.resizer(
  theme.color = "blue",
  position = "top",
  font.size = "12px",
  font.color = "brown",
  tables = TRUE,
  images = TRUE,
  line.color = "green",
  line.width = 150,
  line.height = 5,
  default.image.width = "40\%"
) # customized settings

}
