/*
 * Copyright (c) 2024 Villu Ruusmann
 *
 * This file is part of JPMML-R
 *
 * JPMML-R is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JPMML-R is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with JPMML-R.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.jpmml.rexp;

abstract
public class REnvironment extends RExp {

	private RPair variables = null;


	REnvironment(){
		super(null);
	}

	public RExp findVariable(String name){
		RPair variable = getVariables();

		while(variable != null){

			if(variable.tagEquals(name)){
				return variable.getValue();
			}

			variable = variable.getNext();
		}

		return null;
	}

	public RPair getVariables(){
		return this.variables;
	}

	void setVariables(RPair variables){
		this.variables = variables;
	}

	public static final REnvironment EMPTY = new REnvironment(){
	};
}