/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.neural_network;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.neural_network.PMMLAttributes;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Con", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="Con")
@JsonPropertyOrder(value={"from", "weight", "extensions"})
public class Connection
extends PMMLObject
implements HasExtensions<Connection> {
    @XmlAttribute(name="from", required=true)
    @JsonProperty(value="from")
    private String from;
    @XmlAttribute(name="weight", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="weight")
    private Number weight;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public Connection() {
    }

    @ValueConstructor
    public Connection(@Property(value="from") String from, @Property(value="weight") Number weight) {
        this.from = from;
        this.weight = weight;
    }

    public String requireFrom() {
        if (this.from == null) {
            throw new MissingAttributeException(this, PMMLAttributes.CONNECTION_FROM);
        }
        return this.from;
    }

    public String getFrom() {
        return this.from;
    }

    public Connection setFrom(@Property(value="from") String from) {
        this.from = from;
        return this;
    }

    public Number requireWeight() {
        if (this.weight == null) {
            throw new MissingAttributeException(this, PMMLAttributes.CONNECTION_WEIGHT);
        }
        return this.weight;
    }

    public Number getWeight() {
        return this.weight;
    }

    public Connection setWeight(@Property(value="weight") Number weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Connection addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

