% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_publications.R
\name{get_publications}
\alias{get_publications}
\title{Get PGS Catalog Publications}
\usage{
get_publications(
  pgp_id = NULL,
  pgs_id = NULL,
  pubmed_id = NULL,
  author = NULL,
  set_operation = "union",
  interactive = TRUE,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{pgp_id}{A character vector of PGS Catalog publication accession
identifiers.}

\item{pgs_id}{A \code{character} vector of PGS Catalog score accession
identifiers.}

\item{pubmed_id}{An \code{integer} vector of
\href{https://en.wikipedia.org/wiki/PubMed}{PubMed} identifiers.}

\item{author}{A character vector of author names, any author in the list of
authors in a publication, .e.g. \code{'Mavaddat'}.}

\item{set_operation}{Either \code{'union'} or \code{'intersection'}. This
tells how publications retrieved by different criteria  should be combined:
\code{'union'} binds together all results removing duplicates and
\code{'intersection'} only keeps same publications found with different
criteria.}

\item{interactive}{A logical. If all publications are requested, whether to ask
interactively if we really want to proceed.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A \linkS4class{publications} object.
}
\description{
Retrieves PGS publications via the PGS Catalog REST API. The REST
API is queried multiple times with the criteria passed as arguments (see
below). By default all publications that match the criteria supplied in the
arguments are retrieved: this corresponds to the default option
\code{set_operation} set to \code{'union'}. If you rather have only the
associations that match simultaneously all criteria provided, then set
\code{set_operation} to \code{'intersection'}.
}
\details{
Please note that all search criteria are vectorised, thus allowing for batch
mode search. For more details see the help vignette:
\code{vignette("getting-pgs-publications", package = "quincunx")}.
}
\examples{
\dontrun{
# Get PGS publications by their identifier
get_publications(pgp_id = c('PGP000001', 'PGP000002'))

# By polygenic score identifier
get_publications(pgs_id = 'PGS000003')

# By PubMed identifier
get_publications(pubmed_id = '30554720')

# By author's last name
get_publications(author = 'Natarajan')
}
}
