% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-publications}
\alias{subset-publications}
\alias{[,publications,missing,missing,missing-method}
\alias{[,publications,numeric,missing,missing-method}
\alias{[,publications,character,missing,missing-method}
\title{Subset a publications object}
\usage{
\S4method{[}{publications,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{publications,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{publications,character,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{publications} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{publications} object.
}
\description{
You can subset \linkS4class{publications} by identifier or by position using
the \code{`[`} operator.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all publications in the PGS Catalog:
all_pub <- get_publications(interactive = FALSE, progress_bar = FALSE)

#
# Subsetting by position
#
all_pub[1:5]

#
# Subsetting by publication identifier (character)
#
all_pub['PGP000001']
\dontshow{\}) # examplesIf}
}
\keyword{internal}
