% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quilt_form.R
\name{quilt_form}
\alias{quilt_form}
\title{Create text labelling form for importing to Qualtrics}
\usage{
quilt_form(input_data, page_break_every = 0, question_type, filename)
}
\arguments{
\item{input_data}{data.frame: input data generated with \code{quilt_form_data()}}

\item{page_break_every}{integer: number of text examples before page break; default is 0}

\item{question_type}{character vector: one of c("dropdown", "select", "multiselect", "singleanswer", "multianswer", "rankorder", "singleline", "essay" )}

\item{filename}{name of survey .txt form generated, e.g. "quilted_form.txt."}
}
\value{
a .txt survey file
}
\description{
Create text labelling form for importing to Qualtrics
}
\examples{
\dontrun{

data(lipsum_text)

qdat <- quilt_form_data(prompt = "Label this text: ", text = lipsum_text$text,
                        response_type = "scale", nlow = 1, nhigh = 10, addID = T)

quilt_form(input_data = qdat, page_break_every = 1,
                 question_type = "multianswer", filename = "test/testing.txt")
}
}
