% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randompair.R
\name{randompair}
\alias{randompair}
\title{randompair}
\usage{
randompair(players, k, cores = 1)
}
\arguments{
\item{players}{vector, indicating a list of players.}

\item{k}{numeric, indicating how many players each player will be paired with.}

\item{cores}{numeric, indicating the number of CUP cores to be used for parallel}
}
\value{
dataframe
}
\description{
ramdonly pair players using reservoir sampling method.
}
\examples{
players <- c(1, 'a', 'c', 4, 7, 2, 'w', 'y', 3, 0, 8)
pw <- quickPWCR::randompair(players = players, k = 3)

}
\references{
JVitter, J. S. (1985). Random sampling with a reservoir.
ACM Transactions on Mathematical Software (TOMS), 11(1), 37-57.
}
