% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{changes}
\alias{changes}
\title{Change Scores from Numeric Data}
\usage{
changes(data, vrb.nm, n, undefined = NA, suffix)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{n}{integer vector with length 1. Specifies how the change score is
calculated. If \code{n} is positive, then the change score is calculated
from lead - original; if \code{n} is negative, then the change score is
calculated from original - lag. The magnitude of \code{n} determines how
many rows are shifted for the lead/lag within the calculation. See details
of \code{\link{shifts}}.}

\item{undefined}{atomic vector with length 1 (probably makes sense to be the
same typeof as \code{x}). Specifies what to insert for undefined values
after the shifting takes place. See details of \code{\link{shifts}}.}

\item{suffix}{character vector of length 1 specifying the string to append to
the end of the colnames of the return object. The default depends on the
\code{n} argument: 1) if \code{n} < 0, then \code{suffix} =
\code{paste0("_hg", -n)}, 2) if \code{n} > 0, then \code{suffix} =
\code{paste0("_hd", +n)}, 3) if \code{n} = 0, then \code{suffix} = "".}
}
\value{
data.frame of change scores with colnames specified by
  \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{changes} creates change scores (aka difference scores) from numeric
data. It is assumed that the data is already sorted by time such that the
first row is earliest in time and the last row is the latest in time.
\code{changes} is a multivariate version of \code{\link{change}} that operates
on multiple variabes rather than just one.
}
\details{
It is recommended to use \code{L} when specifying \code{n} to prevent
problems with floating point numbers. \code{shifts} tries to circumvent this
issue by a call to \code{round} within \code{shifts} if \code{n} is not an
integer; however that is not a complete fail safe. The problem is that
\code{as.integer(n)} implicit in \code{shifts} truncates rather than rounds.
See details of \code{\link{shifts}}.
}
\examples{
changes(attitude, vrb.nm = names(attitude),
   n = -1L) # use L to prevent problems with floating point numbers
changes(attitude, vrb.nm = names(attitude),
   n = -2L) # can specify any integer up to the length of `x`
changes(attitude, vrb.nm = names(attitude),
   n = +1L) # can specify negative or positive integers
changes(attitude, vrb.nm = names(attitude),
   n = +2L, undefined = -999) # user-specified indefined value
changes(attitude, vrb.nm = names(attitude),
   n = -2L, undefined = -999) # user-specified indefined value
\dontrun{
changes(str2str::d2d(InsectSprays), names(InsectSprays),
  n = 3L) # character vector returns an error
}
}
\seealso{
\code{\link{change}}
   \code{\link{changes_by}}
   \code{\link{change_by}}
   \code{\link{shifts}}
}
