% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal_kernels.R
\name{k_t}
\alias{k_t}
\title{Dispersal kernels from spatial t distribution}
\usage{
k_t(x, par, N = 1, d = NCOL(x))
}
\arguments{
\item{x}{Numeric matrix of positions \eqn{x} relative to the seed source,
or vector of distances \eqn{\left\|{x}\right\|} to the seed source.}

\item{par}{Numeric vector with two elements representing the
log-transformed parameters \eqn{a} and \eqn{b}.}

\item{N}{The multiplier \eqn{N}.}

\item{d}{The spatial dimension.}
}
\value{
Numeric vector of function values \eqn{k(x)} multiplied by \eqn{N}.
}
\description{
\code{k_t} computes the value, multiplied by \eqn{N}, of the dispersal kernel
from Clark et al. (1999) that represents a multivariate t distribution.
}
\details{
The dispersal kernel, i.e. spatial probability density
of the location of a seed relative to its source, is here given by
\deqn{k(x)={\Gamma ((b+d)/2) \over \pi ^{d/2}a^{d}\Gamma (b/2)}
  (1+{\left\|{x}\right\|^{2} \over a^{2}})^{-(b+d)/2},}
which corresponds to a probability density of the distance given by
\deqn{p(r)={2 \over a^{d}B(d/2,b/2)}r^{d-1}
  (1+{r^{2} \over a^{2}})^{-(b+d)/2},}
where \eqn{d} is the spatial dimension, \eqn{\left\|{\,}\right\|}
denotes the Euclidean norm and the normalizing constants involve the
\link[base:beta]{beta} and \link[base:gamma]{gamma} functions; see Clark
et al. (1999) and Austerlitz et al. (2004) for the planar case (with
\eqn{a,b} replaced by \eqn{\sqrt{u},2p} and
\eqn{a,2b-d}, respectively). This means the position is
\eqn{a \over \sqrt{b}} times a random vector having a standard
\eqn{d}-variate t distribution with \eqn{b} degrees of freedom (a standard
Gaussian vector divided by \eqn{\sqrt{z/b}}, where \eqn{z} is independent
and chi-squared distributed with \eqn{b} degrees of freedom), and the
squared distance is \eqn{da^{2} \over b} times a random variable having an
\link[stats:FDist]{F distribution} with \eqn{d} and \eqn{b} degrees of
freedom.

This results from the kernel being defined as a mixture of Gaussian
kernels with an inverse variance having a
\link[stats:GammaDist]{gamma distribution} with shape parameter
\eqn{b\over 2} and inverse scale parameter \eqn{a^{2}\over 2}, which for
\eqn{a=1} is a \link[stats:Chisquare]{chi-squared distribution} with
\eqn{b} degrees of freedom.

The dispersal kernel always has its maximum at zero, and the distance has
a fat-tailed distribution for all choices of \eqn{b}.
}
\examples{
k_t(2:5, par=c(0,0), d=2)
}
\references{
Clark, J.S., Silman, M., Kern, R., Macklin, E., HilleRisLambers, J.
(1999). Seed dispersal near and far: patterns across temperate and
tropical forests. \emph{Ecology} \strong{80}, 1475–1494.
\doi{10.1890/0012-9658(1999)080[1475:SDNAFP]2.0.CO;2}

Austerlitz, F., Dick, C.W., Dutech, C., Klein, E.K., Oddou-Muratorio, S.,
Smouse, P.E., Sork, V.L. (2004). Using genetic markers to estimate the
pollen dispersal curve. \emph{Molecular Ecology} \strong{13}, 937–954.
\doi{10.1111/j.1365-294X.2004.02100.x}
}
