% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-bookdown.R
\name{detect_bookdown_crossrefs}
\alias{detect_bookdown_crossrefs}
\title{Detect Bookdown Cross-References for Quarto Migration}
\usage{
detect_bookdown_crossrefs(path = ".", verbose = FALSE)
}
\arguments{
\item{path}{Character string. Path to a single \code{.Rmd} or \code{.qmd} file, or a
directory containing such files. Defaults to current directory (\code{"."}).

Typically used for Bookdown projects or R Markdown documents using
bookdown output formats (e.g., \code{bookdown::pdf_document2}).}

\item{verbose}{Logical. If \code{TRUE}, shows detailed line-by-line breakdown of
all cross-references found. If \code{FALSE} (default), shows compact summary
by file.}
}
\value{
Invisibly returns a list of detected cross-references with their
file locations, line numbers, and conversion details. Returns \code{NULL} if
no cross-references are found.
}
\description{
Scans R Markdown or Quarto files to identify bookdown cross-references that
need to be converted to Quarto syntax. Provides detailed reports and guidance
for migrating from bookdown to Quarto.
}
\details{
This function helps users migrate from bookdown to Quarto by detecting
cross-references that use bookdown syntax and need manual conversion.
\subsection{Detected Cross-Reference Types}{

\strong{Auto-detectable conversions:}
\itemize{
\item Figures: \verb{\\@ref(fig:label)}-> \verb{@fig-label}
\item Tables: \verb{\\@ref(tab:label)} -> \verb{@tbl-label}
\item Equations: \verb{\\@ref(eq:label)} -> \verb{@eq-label}
\item Sections: \verb{\\@ref(label)} -> \verb{@sec-label}
\item Theorems: \verb{\\@ref(thm:label)} -> \verb{@thm-label} (also lem, cor, prp, def, exm, exr)
}

\strong{Manual conversion required:}
\itemize{
\item Numbered equations: \verb{(\\#eq:label)} -> requires equation restructuring
\item Theorem blocks: Need explicit Quarto div syntax conversion
All three formats from several bookdown versions are supported:
\itemize{
\item Old syntax with label: \verb{\{theorem, label="thm:label"\}}
\item Old syntax without label: \verb{\{theorem chunk_name\}}
\item New div syntax: \verb{::: \{.theorem #thm-label\}}
}
\item Section headers: Need explicit \verb{\{#sec-label\}} IDs
\item Figure labels: Need explicit \verb{#| label: fig-label} in code chunks
\item Table labels: Need explicit \verb{#| label: tbl-label} in code chunks
}

\strong{Unsupported in Quarto:}
\itemize{
\item Conjecture (\code{cnj}) and Hypothesis (\code{hyp}) references
}
}

\subsection{Adaptive Guidance}{

The function provides \strong{context-aware warnings} that only show syntax patterns
actually found in your files. For example, if your project only uses the old
theorem syntax without labels, you'll only see guidance for that specific pattern,
not all possible variations.
}

\subsection{Output Modes}{

\strong{Default (\code{verbose = FALSE}):}
\itemize{
\item Compact file-by-file summary
\item Cross-reference counts by type
\item Manual conversion requirements summary
}

\strong{Verbose (\code{verbose = TRUE}):}
\itemize{
\item Detailed line-by-line breakdown
\item Exact bookdown -> Quarto syntax transformations
\item Context-aware conversion guidance showing only relevant syntax patterns
\item Comprehensive examples with documentation links
}
}
}
\examples{
\dontrun{
# Scan current directory (compact output)
detect_bookdown_crossrefs()

# Scan specific file with detailed output
detect_bookdown_crossrefs("my-document.Rmd", verbose = TRUE)

# Scan directory with context-aware guidance
detect_bookdown_crossrefs("path/to/bookdown/project", verbose = TRUE)
}

}
\seealso{
\strong{Bookdown documentation:}
\itemize{
\item General: \href{https://bookdown.org/yihui/bookdown/}{Bookdown book}
\item \href{https://bookdown.org/yihui/bookdown/cross-references.html}{Cross-references}
\item \href{https://bookdown.org/yihui/bookdown/figures.html}{Figures}
\item \href{https://bookdown.org/yihui/bookdown/tables.html}{Tables}
\item \href{https://bookdown.org/yihui/bookdown/markdown-extensions-by-bookdown.html#equations}{Equations}
\item \href{https://bookdown.org/yihui/bookdown/markdown-extensions-by-bookdown.html#theorems}{Theorems}
}

\strong{Quarto documentation:}
\itemize{
\item \href{https://quarto.org/docs/authoring/cross-references.html}{Cross-references}
\item \href{https://quarto.org/docs/authoring/cross-references-divs.html}{Cross-references with divs}
\item \href{https://quarto.org/docs/authoring/figures.html#cross-references}{Figure cross-references}
\item \href{https://quarto.org/docs/authoring/tables.html#cross-references}{Table cross-references}
}
}
