% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens.R
\name{concat}
\alias{concat}
\alias{concatenator}
\title{Return the concatenator character from an object}
\usage{
concat(x)

concatenator(x)
}
\arguments{
\item{x}{a \link{tokens} object}
}
\value{
a character of length 1
}
\description{
Get the concatenator character from a \link{tokens} object.
}
\details{
The concatenator character is a special delimiter used to link
separate tokens in multi-token phrases.  It is embedded in the meta-data of
tokens objects and used in downstream operations, such as \code{\link[=tokens_compound]{tokens_compound()}}
or \code{\link[=tokens_lookup]{tokens_lookup()}}.  It can be extracted using \code{\link[=concat]{concat()}} and set using
\code{tokens(x, concatenator = ...)} when \code{x} is a tokens object.

The default \verb{_} is recommended since it will not be removed during normal
cleaning and tokenization (while nearly all other punctuation characters, at
least those in the Unicode punctuation class \verb{[P]} will be removed).
}
\examples{
toks <- tokens(data_corpus_inaugural[1:5])
concat(toks)

}
