% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_svmlin.R
\name{textmodel_svmlin}
\alias{textmodel_svmlin}
\title{[experimental] Linear SVM classifier for texts}
\usage{
textmodel_svmlin(
  x,
  y,
  intercept = TRUE,
  lambda = 1,
  cp = 1,
  cn = 1,
  scale = FALSE,
  center = FALSE
)
}
\arguments{
\item{x}{the \link[quanteda:dfm]{dfm} on which the model will be fit.  Does not
need to contain only the training documents.}

\item{y}{vector of training labels associated with each document identified
in \code{train}.  (These will be converted to factors if not already factors.)}

\item{intercept}{logical; if \code{TRUE}, add an intercept to the data}

\item{lambda}{numeric; regularization parameter lambda (default 1)}

\item{cp}{numeric; Relative cost for "positive" examples (the second factor
level)}

\item{cn}{numeric; Relative cost for "negative" examples (the first factor
level)}

\item{scale}{logical; if \code{TRUE}, normalize the feature counts}

\item{center}{logical; if \code{TRUE}, centre the feature counts}
}
\value{
a fitted model object of class \code{textmodel_svmlin}
}
\description{
Fit a fast linear SVM classifier for sparse text matrices, using svmlin C++
code written by Vikas Sindhwani and S. Sathiya Keerthi.  This method
implements the modified finite Newton L2-SVM method (L2-SVM-MFN) method
described in Sindhwani and Keerthi (2006). Currently,
\code{textmodel_svmlin()} only works for two-class problems.
}
\section{Warning}{

This function is marked experimental since it's not fully working yet in a
way that translates into more standard SVM parameters that we understand. Use
with caution after reading the Sindhwani and Keerthi (2006) paper.
}

\examples{
# use Lenihan for govt class and Bruton for opposition
library("quanteda")
docvars(data_corpus_irishbudget2010, "govtopp") <- c("Govt", "Opp", rep(NA, 12))
dfmat <- dfm(tokens(data_corpus_irishbudget2010))

tmod <- textmodel_svmlin(dfmat, y = dfmat$govtopp)
predict(tmod)
}
\references{
Vikas Sindhwani and S. Sathiya Keerthi (2006).  \href{https://vikas.sindhwani.org/sk_sigir06.pdf}{Large Scale Semi-supervised Linear SVMs}. \emph{Proceedings of ACM
SIGIR}. August 6–11, 2006, Seattle.

V. Sindhwani and S. Sathiya Keerthi (2006).  Newton Methods for Fast Solution
of Semi-supervised Linear SVMs. Book Chapter in \emph{Large Scale Kernel
Machines}, MIT Press, 2006.
}
\seealso{
\code{\link[=predict.textmodel_svmlin]{predict.textmodel_svmlin()}}
}
\keyword{experimental}
\keyword{internal}
\keyword{textmodel}
