% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_ca.R
\name{coef.textmodel_ca}
\alias{coef.textmodel_ca}
\alias{coefficients.textmodel_ca}
\title{Extract model coefficients from a fitted textmodel_ca object}
\usage{
\method{coef}{textmodel_ca}(object, doc_dim = 1, feat_dim = 1, ...)

coefficients.textmodel_ca(object, doc_dim = 1, feat_dim = 1, ...)
}
\arguments{
\item{object}{a fitted \link{textmodel_ca} object}

\item{doc_dim, feat_dim}{the document and feature dimension scores to be
extracted}

\item{...}{unused}
}
\value{
a list containing numeric vectors of feature and document
coordinates.  Includes \code{NA} vectors of standard errors for consistency with
other models' coefficient outputs, and for the possibility of having these
computed in the future.
\itemize{
\item \code{coef_feature} column coordinates of the features
\item \code{coef_feature_se} feature length vector of \code{NA} values
\item \code{coef_document} row coordinates of the documents
\item \code{coef_document_se} document length vector of \code{NA} values
}
}
\description{
\code{coef()} extract model coefficients from a fitted \code{textmodel_ca}
object.  \code{coefficients()} is an alias.
}
\keyword{internal}
\keyword{textmodel}
