% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llqrcv.R
\name{llqrcv}
\alias{llqrcv}
\title{Cross-Validation for bandwidth selection of local linear quantile regression}
\usage{
llqrcv(x, y, tau = 0.5)
}
\arguments{
\item{x}{A design matrix (n x p).  The rows represent observations and the
columns represent predictor variables.}

\item{y}{A vector of the response variable.}

\item{tau}{A quantile level, a number strictly between 0 and 1.}
}
\value{
\code{llqrcv} returns the optimal bandwidth selected using
Cross-Validation criterion for the local linear fit of the \eqn{\tau}th
conditional quantile of \code{y} given \code{x}.
}
\description{
\code{llqrcv} estimates the bandwidth necessary for the local linear fit of
the \eqn{\tau}th conditional quantile of \code{y} given \code{x}.  The
estimation is performed using the Cross-Validation criterion.
}
\details{
A grid of bandwidth values is created and the local linear fit is estimated
using all the data points except for one point, which is used to make the
prediction.  This procedure is repeated \code{n} times, where \code{n} is the
number of observations.  Then, the bandwidth is selected as the one with the
smallest average error.

When the dimension of the predictor variable is large compared with the sample
size, local linear fitting meets the 'curse of dimensionality' problem. In
situations like that, the grid bandwidth values might be too small and cause
the function to fail. For these cases, we advice the user to directly use the
\code{llqr} function of the package and specify a bandwidth in the function.
}
\examples{
set.seed(1234)
n <- 100
x <- rnorm(n)
error <- rnorm(n)
y <- x^2 + error
tau <- 0.5
llqrcv(x, y, tau = tau)
}
