% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize.R
\name{categorize}
\alias{categorize}
\title{Categorize data based on contents of a column}
\usage{
categorize(data, column, values, name, binary = TRUE, exact = TRUE, categories)
}
\arguments{
\item{data}{The data frame.}

\item{column}{The column name which contains the data on which to categorize
rows.}

\item{values}{The characters or parts of characters to use to classify rows.}

\item{name}{The name of the now column of categories.}

\item{binary}{If \code{binary = TRUE}, the \code{name} column will be returned with "Yes"
denoting that characters ,or parts of characters specified by
\code{values} are present in the row, while "No" denotes that there are no
characters or parts of characters specified in \code{values} present in the row.
If \code{binary =  FALSE} there must be \code{categories} provided which will be used
to classify the presence of characters or parts of characters specified in
\code{values}.}

\item{exact}{If \code{exact = TRUE} only exact matches will be selected. If \code{exact = FALSE}
matches will be selected if they contain the characters in the
\code{values} vector and will not be limited by exact matches.}

\item{categories}{The factor names denoting the presence of the characters or
parts of characters specified by \code{values}. These must be specified in the
same order as the corresponding element in \code{values}.}
}
\value{
A data frame with new categorization column.
}
\description{
Using a column within the data frame, categorize rows in a binary
of yes or no, or customize with a set of category names. Data can be categorized
based on the inclusion or lack of inclusion of parts of characters, or based on
exact characters. Especially useful for turning ID tags into useful categories
for analysis such as morphology, bleaching, taxonomy etc.
}
\examples{
Sites <- as.factor(c("One", "One", "One", "Two", "Two", "Three"))
Transect <- as.factor(c("1-Deep", "1-Shallow", "2-Shallow", "1-Shallow", "1-Deep", "1-Deep"))
Acropora.sp <- c(0.1, 0.6, 0.4, 0.9, 0.2, 0.5)
Gardineroseris.sp <- c(0.4, 0.9, 0.5, 0.23, 0.5, NA)
Psammocora.sp <- c(0.9, 0.6, 0.5, 0.8, 0.1, 0.4)
Leptastrea.sp <- c(0.5, 0.7, 0.4, 0.8, 0.2, NA)
Notes <- c(NA, NA, "saw octopus", NA, "white balance corrected", NA)
coral_cover <- data.frame(Sites, Transect, Acropora.sp, Gardineroseris.sp,
                          Psammocora.sp, Leptastrea.sp, Notes)

# Classify shallow transects in a binary column
categorize(data = coral_cover, column = "Transect", values = "Shallow",
    name = "Shallow", binary = TRUE, exact = FALSE)

# Classify depth of transect in a new column based on transect name
categorize(data = coral_cover, column = "Transect", values = c("Shallow", "Deep"),
    name = "Depth", binary = FALSE, categories = c("S", "D"), exact = FALSE)


}
