% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotCorr.R
\name{iplotCorr}
\alias{iplotCorr}
\title{Image of correlation matrix with linked scatterplot}
\usage{
iplotCorr(
  mat,
  group = NULL,
  rows = NULL,
  cols = NULL,
  reorder = FALSE,
  corr = NULL,
  scatterplots = TRUE,
  chartOpts = NULL,
  digits = 5
)
}
\arguments{
\item{mat}{Data matrix (individuals x variables)}

\item{group}{Optional vector of groups of individuals (e.g., a genotype)}

\item{rows}{Selected rows of the correlation matrix to include in
the image. Ignored if `corr` is provided.}

\item{cols}{Selected columns of the correlation matrix to include
in the image. Ignored if `corr` is provided.}

\item{reorder}{If TRUE, reorder the variables by
clustering. Ignored if `corr` is provided as a subset of the
overall correlation matrix}

\item{corr}{Correlation matrix (optional).}

\item{scatterplots}{If `FALSE`, don't have the heat map be
linked to scatterplots.}

\item{chartOpts}{A list of options for configuring the chart (see
the coffeescript code). Each element must be named using the
corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class `htmlwidget` that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph with an image of a
correlation matrix linked to underlying scatterplots.
}
\details{
`corr` may be provided as a subset of the overall
correlation matrix for the columns of `mat`. In this case, the
`reorder`, `rows` and `cols` arguments are ignored. The row and
column names of `corr` must match the names of some subset of
columns of `mat`.

Individual IDs are taken from `rownames(mat)`; they must match
`names(group)`.
}
\examples{
data(geneExpr)
\donttest{
iplotCorr(geneExpr$expr, geneExpr$genotype, reorder=TRUE,
          chartOpts=list(cortitle="Correlation matrix",
                         scattitle="Scatterplot"))}

# use Spearman's correlation
corr <- cor(geneExpr$expr, method="spearman", use="pairwise.complete.obs")
# order by hierarchical clustering
o <- hclust(as.dist(1-corr))$order
\donttest{
iplotCorr(geneExpr$expr[,o], geneExpr$genotype, corr=corr[o,o],
          chartOpts=list(cortitle="Spearman correlation",
                         scattitle="Scatterplot"))}
}
\seealso{
[iheatmap()], [scat2scat()], [iplotCurves()]
}
\keyword{hplot}
