% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{write_qst}
\alias{write_qst}
\title{Write a data.frame to an SQLite database}
\usage{
write_qst(x, path, ..., unique_indexes = NULL, indexes = NULL)
}
\arguments{
\item{x}{A data.frame to be written to file. Supported
column types are integer, numeric and character.}

\item{path}{The path to write to.}

\item{...}{Other parameters passed to methods.}

\item{unique_indexes}{A list of character vectors.
Each element of the list will create a new unique
index over the specified column(s). Duplicate rows
will result in failure.}

\item{indexes}{A list of character vectors. Each
element of the list will create a new index.}
}
\value{
The original data frame passed in x
}
\description{
This function writes a data.frame to an SQLite database.
The database has one table, named data, containing the data.
Additional tables, prefixed with meta_, may be added in the
future to support additional data types not supported
in a native way by SQLite.
}
\examples{
# Write the cars data set to a file
cars_db <- tempfile()
write_qst(cars, cars_db, indexes=list("speed"))
unlink(cars_db)

}
