% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{substituteQspray}
\alias{substituteQspray}
\title{Substitutions in a 'qspray' polynomial}
\usage{
substituteQspray(qspray, values)
}
\arguments{
\item{qspray}{a \code{qspray} object}

\item{values}{the values to be substituted; this must be a vector whose 
length equals the number of variables of \code{qspray}, and whose each 
entry is either \code{NA} (for non-substitution) or a 'scalar' \code{x} 
such that \code{as.character(x)} is a quoted integer or a quoted fraction}
}
\value{
A \code{qspray} object.
}
\description{
Substitute some variables in a \code{qspray} polynomial.
}
\examples{
library(qspray)
x <- qlone(1)
y <- qlone(2)
z <- qlone(3)
p <- x^2 + y^2 + x*y*z - 1
substituteQspray(p, c("2", NA, "3/2"))
}
