% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.qris}
\alias{plot.qris}
\title{Draw 95\% confidence interval by a quantile regression estimator of residual lifetime from survival data}
\usage{
\method{plot}{qris}(
  x,
  t0s = NULL,
  Qs = NULL,
  nB = NULL,
  vari = NULL,
  byQs = FALSE,
  ggextra = NULL,
  ...
)
}
\arguments{
\item{x}{is an "\code{qris}" object or a data.frame returned by \code{plot.qris}.}

\item{t0s}{is a vector of range of \code{t0} to plot;
when not specified, the default value is from 0 to presently defined \eqn{t_0}}

\item{Qs}{is a vector of range of \code{Q} to plot;
when not specified, the default value is from 5\% to presently defined \eqn{Q}}

\item{nB}{is the number of multiplier bootstrapping for standard error estimation.}

\item{vari}{is a character string to choose variables to draw the regression coefficient.}

\item{byQs}{put \code{Q}'s on x-axis; only used when both \code{t0}'s and \code{Q}'s are specified.}

\item{ggextra}{is a list that contains additional components to apply to the \code{ggplot} output.
The \code{ggplot2} library must be loaded in order to utilize this feature.}

\item{...}{for future extension}
}
\value{
A list contains \code{ggplot} object and the information to generate it.
}
\description{
Draw 95\% confidence interval by a quantile regression estimator of residual lifetime from survival data
}
\examples{
data(cancer, package = "survival")
lung2 <- subset(lung, select = c(time, status, age, sex))
## tidy up the data
lung2$status <- lung2$status - 1
lung2$sex <- lung2$sex - 1

library(qris)
fm <- Surv(time, status) ~ age + sex
fit <- qris(fm, data = lung2, t0 = 30, Q = 0.5, nB = 50, "nonsmooth", "fmb")

## Plot with default values; Qs <- 1:9 / 10 and t0s = fit2$para$t0 (in this case 30)
plot(fit)

## Plot with without 95\% CI is much faster
plot(fit, nB = 0)

## Plot feature can update qris calls 
fit <- plot(fit, Qs = 3:6 / 10, t0s = 1:6 * 10)

## Faster after updating the qris call
plot(fit, byQs = FALSE)
plot(fit, byQs = TRUE)

plot(fit, byQs = FALSE, vari = c("sex", "age"))
plot(fit, byQs = TRUE, vari = c("sex", "age"))

## Extra ggplot components
library(ggplot2)
plot(fit, byQs = FALSE, vari = c("sex", "age"), ggextra = theme(legend.position = "none"))
}
