% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{varType}
\alias{varType}
\title{varType}
\usage{
varType(data, include = NULL, exclude = NULL, ndistinct = 10, nnonnum = 20)
}
\arguments{
\item{data}{data frame or table to analyze}

\item{include}{formula or vector of variable names to attend to}

\item{exclude}{a formula or character vector specifying which variables to exclude from consideration}

\item{ndistinct}{minimum number of distinct numeric values a variable must have to be considered continuous}

\item{nnonnum}{maximum number of distinct values a variable can have to be considered discrete}
}
\value{
\code{list} of vectors
}
\description{
Determine Types of Variables
}
\details{
For all the variables in a data frame/table, analyzes them to determine types: continuous, nonnumeric, and discrete.  \code{include} and \code{exclude} can be vector or right-side-only formulas.
}
\examples{
set.seed(1)
d <- data.frame(i=1:100, x=runif(100), y=sample(1:3, 100, TRUE),
                w=sample(c('cat','dog','giraffe'), 100, TRUE),
                v=sample(letters, 100, TRUE))
varType(d)
}
\author{
Frank Harrell
}
