% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_info}
\alias{get_info}
\title{Gets raw financial statements from Google Finance.}
\usage{
get_info(companies = qmj::companies_r3k16)
}
\arguments{
\item{companies}{A data frame of companies. Must have a ticker column.}
}
\value{
A list with three elements. Each element is a list containing
all financial documents of a specific type for each company. These lists are, in order,
all cash flow statements, all income statements, and all balance sheets.
}
\description{
\code{get_info} grabs annual financial data for a given data frame of companies.
}
\details{
For each ticker in the data frame of companies, \code{get_info} grabs
financial data using the quantmod package and generates a list with 
three sub-lists. Also writes .RData files to the user's temporary directory. 
If cancelled partway through, \code{get_info} is able to find and re-read this
data, quickly resuming its progress. Once complete, \code{get_info} deletes
all used temporary data.

Parameter data frame defaults to provided \code{companies_r3k16} data set if not specified.
}
\examples{
\donttest{
# Takes more than 10 secs
if (reticulate::py_module_available("yfinance")) 
  get_info(companies_r3k16[companies_r3k16$ticker \%in\% c("AAPL", "AMZN"), ])
}

}
\seealso{
\code{\link{get_prices}}

\code{\link{clean_downloads}}

\code{\link{tidyinfo}}
}
