% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_downloads.R
\name{clean_downloads}
\alias{clean_downloads}
\title{Removes downloaded temporary files.}
\usage{
clean_downloads(x = qmj::companies_r3k16)
}
\arguments{
\item{x}{A data frame of companies. Must have a ticker column.}
}
\value{
A logical vector Where the (2i-1)th and (2i)th element corresponds to
whether or not a temporary financial and/or price file, respectively, 
was found and removed for the ith company provided. 

For example, if AAPL was our 3rd company, for which we had not 
partially downloaded financial data, but did have temporary 
price data, the 5th and 6th elements of the logical vector 
would be FALSE and TRUE, respectively.

The last two indices refer to the S&P 500 temporary data.
}
\description{
\code{clean_downloads} removes files that get_info and get_prices
temporarily store when progress is interrupted while updating. 
Because the temporarily stored data may become irrelvant over time,
clean_downloads removes these files so that get_info and
get_prices will download completely fresh sets of data for a given
data frame of companies.
}
\details{
The clean_downloads() function will also automatically remove any
temporarily stored data for the S&P 500, with the stock ticker ^GSPC.
}
\examples{
clean_downloads()

}
\seealso{
\code{\link{get_prices}}

\code{\link{get_info}}
}
