% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcv.R
\name{qcv}
\alias{qcv}
\title{Quantifying Construct Validity}
\usage{
qcv(n, actr, predr, medr)
}
\arguments{
\item{n}{sample size}

\item{actr}{vector of actual validity correlations}

\item{predr}{vector of predicted validity correlations (in same order as actr)}

\item{medr}{median intercorrelation among criterion variables}
}
\value{
\describe{
  \item{ralerting-CV}{The ralerting-CV effect size}
  \item{rcontrast-CV}{The rcontrast-CV effect size}
  \item{zcontrast}{The zcontrast value}
  \item{p}{p values associated with Zcontrast}
     \item{N}{Sample size}
        \item{k}{Number of criterion variables}
  \item{szr}{Standard deviation of (z-transformed) actual correlations}
  \item{medr}{Median intercorrelation between the critertion variables}
  \item{rbarsq}{Mean of the squared actual correlations (between focal test and criterion variables) }
  \item{t}{t-value associated with p value}
  \item{rem}{"Remarkablness" of size of contrast}
}

Additional values are returned in a list, but not printed
}
\description{
Computes key indices related to the Quantifyting Construct Validity (QCV) procedure (Westen & Rosenthal, 2003; see also Furr & Heuckeroth, in prep.)
}
\details{
This function applies procedures outlined by Westen and Rosenthal (2003; see also Furr & Heuckeroth, in prep).

Important: When entering values for the "actr" and "predr" arguments, order them identically. For example, if
the "actr" values are ordered in terms of c(criterion A, criterion B, criterion C), then the values in "predr" should
be placed in that same order. Otherwise all results will be incorrect.

Note that extreme zcontrast values (e.g., z > 38) create problems. The rcontrast-CV effect size is computed
by converting z to p to t to r (see Westen & Rosenthal, Appendix A & B). However, R (and most other packages)
doesn't have precision to convert an extremely large z (e.g., Z = 38) to a p value. For such z values, the p is converted to exactly
zero. This makes it impossible to obtain t and rcontrast values. The qcv() function handles this by:
a) identifying cases where p is initially exactly zero, and b) re-setting p to the smallest value possible, given the
machine on which R us running (usually  2.225074e-308). It then proceeds to compute a t and rcontrast from that adjusted p value. It also prints a note
stating that the adjustment has been made and that the p, t, and rcontrast values are lower-bound approximations.
}
\examples{
actrIM  <- c(.46, .13, -.24, -.03, .12, .03, .39, .06, .51, .08, .24, .66)
predrIM <- c(.58, .24, -.04, .06, -.04, .18, .36, .08, .64, .56, .36, .56)
qcv(n=90, actr=actrIM, predr=predrIM, medr=.075)
}
\references{
Westen, D., & Rosenthal, R. (2003). Quantifying construct validity: Two simple measures. Journal of Personality and Social Psychology, 84, 608-618.

Furr, R. M., & Heukeroth, S. (In prep).Advancing the Interpretation and Computation of the "Quantifying Construct Validity" Procedure
}
