% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_info}
\alias{get_info}
\title{get_info}
\usage{
get_info(data, inner, outer, modes, scheme, tau, tau_Alg, fix.quantile, ...)
}
\arguments{
\item{data}{matrix or data frame containing the manifest variables.}

\item{inner}{A square (lower triangular) boolean matrix representing 
the inner model (i.e. the path relationships between latent variables).}

\item{outer}{list of vectors with column indices or column names
from \code{data} indicating the sets of manifest variables forming 
each block (i.e. which manifest variables correspond to each block).}

\item{modes}{character vector indicating the type of measurement for each
block. Possible values are: \code{'A', 'B'}. 
The length of \code{modes} must be equal to the length of \code{blocks}.}

\item{scheme}{string indicating the type of inner weighting
scheme. It is equal to \code{"factorial"} by default.
 Possible values are \code{"centroid"}, \code{"factorial"}.}

\item{tau}{if sepcifed indicate the specific quantile to be considered}

\item{tau_Alg}{is the vector of quantile specified by default. It is 
equal to (0.25,0.50,0.75).}

\item{fix.quantile}{is boolean equal to \code{FALSE} or \code{TRUE}
indiciating whether invariance is holded.}

\item{\dots}{Further arguments passed on to \code{\link{get_info}}.}
}
\value{
a string containing generalinformations of the inpunt and output 
parameters of the qcpm algorithm.
}
\description{
get_info
}
\details{
Internal function. \code{get_info} is called by \code{qcpm}.
}
\keyword{internal}
