% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_elicitation.R
\name{prior_build_from_beliefs}
\alias{prior_build_from_beliefs}
\title{Prior Build from Beliefs}
\usage{
prior_build_from_beliefs(
  formula,
  data,
  family = gaussian(),
  beliefs = list(),
  outcome_location = NULL,
  outcome_interval = NULL,
  outcome_level = 0.95,
  outcome_sd = NULL,
  standardise = TRUE,
  plausible_range = NULL,
  target_coverage = 0.8,
  tune = FALSE,
  seed = NULL
)
}
\arguments{
\item{formula}{Model formula}

\item{data}{Data frame}

\item{family}{Model family}

\item{beliefs}{List of beliefs about parameters}

\item{outcome_location}{Expected outcome location}

\item{outcome_interval}{Expected outcome interval}

\item{outcome_level}{Confidence level for outcome interval}

\item{outcome_sd}{Outcome standard deviation}

\item{standardise}{Whether to standardise predictors}

\item{plausible_range}{Plausible range for outcomes}

\item{target_coverage}{Target coverage probability}

\item{tune}{Whether to tune priors}

\item{seed}{Random seed}
}
\value{
An object of class \code{"qbrms_prior_build"} containing:
\itemize{
\item \code{priors}: A list of prior specifications.
\item \code{prior_code}: Character string of R code to reproduce the priors.
\item \code{formula}: The (possibly modified) model formula.
\item \code{data}: The (possibly standardised) data.
\item \code{diagnostics}: Prior predictive diagnostic information.
}
}
\description{
Build priors from elicited beliefs (GLM-aware)
}
