% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_checks.R
\name{pp_check_prior}
\alias{pp_check_prior}
\title{Prior Predictive Checks Without Data}
\usage{
pp_check_prior(
  formula,
  family = gaussian(),
  prior = NULL,
  n_obs = 100,
  ndraws = 100,
  type = "dens_overlay",
  seed = NULL,
  predictor_values = NULL,
  verbose = TRUE
)
}
\arguments{
\item{formula}{Model formula.}

\item{family}{Model family (default \code{gaussian()}).}

\item{prior}{Prior specifications (default \code{NULL}).}

\item{n_obs}{Number of observations to simulate (default \code{100}).}

\item{ndraws}{Number of prior draws (default \code{100}).}

\item{type}{Plot type, one of \code{"dens_overlay"} or \code{"hist"}.}

\item{seed}{Optional random seed.}

\item{predictor_values}{Named list of fixed predictor values (default \code{NULL}).}

\item{verbose}{Logical; print progress messages (default \code{TRUE}).}
}
\value{
A \code{ggplot2} object.
}
\description{
Generate prior predictive samples for a model defined by \code{formula},
without requiring observed data, and return a ggplot object to visualise
the implied distribution.
}
\keyword{internal}
