% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_comparison.R
\name{compare_models}
\alias{compare_models}
\title{Compare qbrms models}
\usage{
compare_models(
  ...,
  criterion = c("auto", "loo", "waic", "dic", "all"),
  compare_predictions = TRUE,
  weights = TRUE
)
}
\arguments{
\item{...}{Two or more fitted model objects (qbrms_fit or qbrmO_fit)}

\item{criterion}{One of "auto","loo","waic","dic","all"}

\item{compare_predictions}{Logical; if TRUE, include RMSE/MAE comparison}

\item{weights}{Logical; if TRUE, compute weights when a single criterion is used}
}
\value{
An object of class \code{"qbrms_comparison"}.
}
\description{
Compares multiple fitted models using information criteria and simple
predictive metrics. Preference order for criterion = "auto" is:
LOO (from CPO) > WAIC > DIC. When information criteria are unavailable
it falls back to predictive metrics (RMSE/MAE).
}
