% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_records.R
\name{update_records}
\alias{update_records}
\title{Insert/Update records}
\usage{
update_records(
  subdomain,
  auth,
  to,
  records,
  mergeFieldId = 3,
  fieldsToReturn = list(3),
  agent = NULL
)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{to}{Character vector. Identifier of the target table.}

\item{records}{Tibble containing the data you want to insert/update in the
target table, where column names correspond to field identifiers.
Alternatively, a list containing record data as json if your data contain
User or List-user data types.}

\item{mergeFieldId}{Character vector. Field identifier of the key field or
unique field to merge upon. Defaults to 3, representing Record ID#.}

\item{fieldsToReturn}{Character vector of field identifiers. Returns data for
field 3 (Record ID#) in addition to any field identifiers supplied.}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
List of JSON containing return data requested via the fieldsToReturn
argument and metadata regarding created/updated records, referenced but
unchanged records, and records having any errors while being processed.
}
\description{
Insert and/or update record(s) in a table. Update can use the key field on
the table, or any other supported unique field. Refer to the
\href{https://developer.quickbase.com/fieldInfo}{Field types page} for more
information about how each field type should be formatted. This operation
allows for incremental processing of successful records, even when some of
the records fail. This endpoint supports a maximum payload size of 10MB.
}
\examples{
\dontrun{
  new_data <- dplyr::tibble(`3` = c(5, 7), `6` = c("A", "B"))
  update_records(subdomain = "bhi",
                 auth = keyring::key_get("qb_example"),
                 to = "bn9d8iesz",
                 records = new_data)
}
}
