% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contents.R
\name{contents}
\alias{contents}
\title{Detailed description of a data frame}
\usage{
contents(data, digits = 2, maxcat = 10, label_length = 20)
}
\arguments{
\item{data}{a data frame}

\item{digits}{number of decimal digits for statistics.}

\item{maxcat}{maximum number of levels of a character/factor
variable to print.}

\item{label_length}{maximum length of factor level label
to print. Longer labels will be truncated.}
}
\value{
a list with 6 components:
\describe{
\item{dfname}{name of data frame}
\item{nrow}{number of rows}
\item{ncol}{number of columns}
\item{overall}{data frame of overall dataset characteristics}
\item{qvars}{data frame with summary statistics for quantitative variables}
\item{cvars}{data frame with summary statistics for categorical variables}
}
}
\description{
\code{contents} provides a comprehensive description of a data
frame, including summary statistics for both quantitative and
categorical variables
}
\details{
Prints a comprehensive description of a data frame via
several tables, a general summary table and tables that provide
a breakdown of quantitative and categorical variables.
}
\examples{
contents(cars74)

}
